/*****************************************************************************
*  LPC11U6x SCT demo program
*
*  Use SCT timer to generate a two-channel double-edge controlled PWM
*  intended for use as a complementary PWM pair with dead-time control
*****************************************************************************/
#include "nxp_lpc11u6x.h"

extern void SCT0_Init(void);

void SCT0_1_IRQHandler(void)
{
    LPC_SCT0->CTRL_L |=  (1 << 3);                     // clear the L counter
    LPC_SCT0->CTRL_L &= ~(1 << 1);                     // start the L counter

    LPC_SCT0->EVFLAG  = (1 << 1);                      // clear event 1 interrupt flag
}

int main (void)
{
    LPC_SYSCON->SYSAHBCLKCTRL |= (1u << 16)            // enable clock for IOCON
                               | (1u << 31);           // enable clock for SCT0/1

    LPC_IOCON->PIO1_25 = 0x00000083;                   // P1_25 is SCT0_IN0 used as ABORT
    LPC_IOCON->PIO1_19 = 0x00000082;                   // P1_19 is SCT0_OUT0
    LPC_IOCON->PIO2_2  = 0x00000083;                   // P2_2  is SCT0_OUT1

    SCT0_Init();                                       // Initialize SCT0

    while (1)                                          // loop forever
    {
    }
}
